catch {load vtktcl}
# Create images from 2D-featflow data
# get the interactor
source /home/kirk2/jacker/vtk/examplesTcl/vtkInt.tcl

# create reader 
vtkUnstructuredGridReader reader
 reader SetFileName "u.17.vtk"
 reader SetScalarsName "pressure"

# create reader1 
vtkUnstructuredGridReader reader1
 reader1 SetFileName "u.17.vtk"
 reader1 SetScalarsName "streamfunction"

# create reader2
vtkUnstructuredGridReader reader2
 reader2 SetFileName "u.17.vtk"
 reader2 SetScalarsName "temperature"

# outline
vtkOutlineFilter outline
    outline SetInput [reader GetOutput]
vtkPolyDataMapper outlineMapper
    outlineMapper SetInput [outline GetOutput]
vtkActor outlineActor
    outlineActor SetMapper outlineMapper
    [outlineActor GetProperty] SetColor 0 0 1                

# FE-Grid
vtkGeometryFilter mygrid
        mygrid SetInput [reader GetOutput]
vtkPolyDataMapper mygridMapper
        mygridMapper SetInput [mygrid GetOutput]
        mygridMapper ScalarVisibilityOff
vtkActor mygridActor
        mygridActor SetMapper mygridMapper            
        [mygridActor GetProperty] SetRepresentationToWireframe
        [mygridActor GetProperty] SetColor 0 0 0                
        mygridActor AddPosition 9.6 0 0

# color table
vtkLookupTable lut
        lut SetHueRange 0.0 0.6667
vtkLookupTable lut2
        lut SetHueRange 0.0 0.6667
vtkLookupTable lut3
	lut SetHueRange 0.0 0.6667

# pressure
vtkGeometryFilter press
        press SetInput [reader GetOutput]
vtkDataSetMapper pressMapper
        pressMapper SetInput [press GetOutput]
        pressMapper ScalarVisibilityOn
        pressMapper SetLookupTable lut
        pressMapper SetScalarRange -0.16848 0.2016 
vtkActor pressActor
        pressActor SetMapper pressMapper            
        [pressActor GetProperty] SetRepresentationToSurface

# streamfunction
vtkGeometryFilter streamf
        streamf SetInput [reader1 GetOutput]
vtkDataSetMapper streamfMapper
        streamfMapper SetInput [streamf GetOutput]
        streamfMapper ScalarVisibilityOn
        streamfMapper SetLookupTable lut2
        streamfMapper SetScalarRange -0.35346 0.027445
vtkActor streamfActor
        streamfActor SetMapper streamfMapper            
        [streamfActor GetProperty] SetRepresentationToSurface
        streamfActor AddPosition 3.2 0 0

# temperature
vtkGeometryFilter temperat
	temperat SetInput [reader2 GetOutput]
vtkDataSetMapper temperatMapper
	temperatMapper SetInput [temperat GetOutput]
	temperatMapper ScalarVisibilityOn
	temperatMapper SetLookupTable lut3
	temperatMapper SetScalarRange 0.0 1.0
vtkActor temperatActor
	temperatActor SetMapper temperatMapper
	[temperatActor GetProperty] SetRepresentationToSurface
	temperatActor AddPosition 6.4 0 0 

# Create graphics stuff
vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1
vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

# Add the actors to the renderer, set the background and size
#ren1 AddActor outlineActor
ren1 AddActor pressActor
ren1 AddActor streamfActor
ren1 AddActor temperatActor
ren1 AddActor mygridActor
[ren1 GetActiveCamera] Azimuth 0
[ren1 GetActiveCamera] Roll 0
[ren1 GetActiveCamera] Dolly 4.5
ren1 SetBackground 1 1 1
renWin SetSize 1000 250

iren Initialize
iren SetUserMethod {wm deiconify .vtkInteract}

renWin SetFileName "test.ppm"
renWin SaveImageAsPPM

# prevent the tk window from showing up then start the event loop
wm withdraw .












