C____________________________________________________________________
C write FEATFLOW results in VTK-format (modified avs2d.f)
C for use in bouss!
C 06.12.1998 G. Kosakowski - g.kosakowski@usa.net
C
C 11.12.1998 for output: changed all Integer-formats to I8
C____________________________________________________________________
      SUBROUTINE XVTK2D(MUNIT,CFILE,NEL,NVT,KVERT,DCORVG,VU,VV,VP,
     *                  VISO,VT)
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B)
C
      CHARACTER SUB*6,FMT*15,CPARAM*120
      CHARACTER CFILE*(*)
      DIMENSION KVERT(4,*),DCORVG(2,*)
      DIMENSION VU(*),VV(*),VP(*),VISO(*),VT(*)
C
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      SAVE
C
C
C
      DO 1 IFIRST = 1,60
      IF (CFILE(IFIRST:IFIRST).EQ.' ') GOTO 2
1     CONTINUE
2     WRITE(CFILE(IFIRST:IFIRST+4),'(A4)') '.vtk'
C
C=======================================================================
C     NVEC = FUNKT.WERTE PRO KNOTEN
C=======================================================================
      NVEC = 5
C
      OPEN (UNIT=MUNIT,FILE=CFILE)
C
C
      WRITE(MUNIT,'(A)')'# vtk DataFile Version 2.0 '
      WRITE(MUNIT,'(A)')'Unstructured Grid FEATFLOW '
      WRITE(MUNIT,'(A)')'ASCII '
      WRITE(MUNIT,'(A)')' '
      WRITE(MUNIT,'(A)')'DATASET UNSTRUCTURED_GRID '
 
      WRITE(MUNIT,'(A7,I8,A6)') 'POINTS ',NVT,' float'
C      WRITE(MUNIT,*) NVT,NEL,NVEC,0,0
C
      DO 100 IVT=1,NVT
100   WRITE(MUNIT,1000) REAL(DCORVG(1,IVT)),REAL(DCORVG(2,IVT)),0E0
C
      WRITE(MUNIT,'(A6,I8,1X,I8)') 'CELLS ',NEL,NEL*5
      DO 110 IEL=1,NEL
110   WRITE(MUNIT,1100) 4,KVERT(1,IEL)-1,KVERT(2,IEL)-1,
     *                               KVERT(3,IEL)-1,KVERT(4,IEL)-1
C
C     cell type specification:
C       VTK_QUAD = 9
C       VTK_HEXAHEDRON = 12
      WRITE(MUNIT,'(A11,I8)') 'CELL_TYPES ',NEL
      DO 120 IEL=1,NEL
120   WRITE(MUNIT,*) 9
C
C

      WRITE(MUNIT,'(A11,I8)') 'POINT_DATA ',NVT
      WRITE(MUNIT,'(A)') 'SCALARS pressure float '
      WRITE(MUNIT,'(A)') 'LOOKUP_TABLE default '
      DO 200 IVT=1,NVT
200   WRITE(MUNIT,1000) VP(IVT)

      WRITE(MUNIT,'(A)') 'SCALARS temperature float '
      WRITE(MUNIT,'(A)') 'LOOKUP_TABLE default '         
      DO 201 IVT=1,NVT
201   WRITE(MUNIT,1000) VT(IVT)

      WRITE(MUNIT,'(A)') 'SCALARS streamfunction float '
      WRITE(MUNIT,'(A)') 'LOOKUP_TABLE default '
      DO 202 IVT=1,NVT
202   WRITE(MUNIT,1000) VISO(IVT)

      WRITE(MUNIT,'(A)') 'VECTORS velocity float '
      DO 203 IVT=1,NVT
203   WRITE(MUNIT,2000) VU(IVT),VV(IVT),0E0

C
C
      REWIND (MUNIT)
      CLOSE  (MUNIT)
C
C
1000  FORMAT(3(1X,F12.5))
1100  FORMAT(5(1X,I8))
2000  FORMAT(3(1X,F12.5))
C
      END










