# common rules for application makefiles
# the application makefile needs to define:
# EXEC    = name of the resulting executable
# FEATLIB = list of feat libs to use (feat2d sysutils are required)
# SRC     = list of source files


OBJDIR=obj/$(ID)
OBJ=$(SRC:%.f=$(OBJDIR)/%.o)

#vpath %.inc include
#vpath %.c src
#vpath %.f src

# if the BLASLIB is not defined add the included blas/lapack to the libs
FEATLIB+= $(if $(BLASLIB),,blas)

FEAT=$(FEATLIB:%=$(LIBDIR)/lib%.a)

all: greet $(EXEC)
	@echo "Done," $(EXEC) "is ready."
	@echo

greet:
	@echo "Compiling module" $(EXEC) "in" 
	@pwd

$(EXEC): $(OBJDIR) $(FEAT) Deps.mk $(OBJ) 
	$(FC) $(FCFLAGS) $(OPTFLAGS) $(OBJ) $(LDFLAGS) $(FEAT) $(BLASLIB) $(LDLIBS) -o $@

$(OBJDIR)/%.o : %.f
	$(FC) $(FCFLAGS) $(OPTFLAGS) $(INCDIR) $(DEFS) -c -o $@ $<

$(OBJDIR):
	mkdir -p $(OBJDIR)

# this checks if the needed libs are ready 
# but it checks only the existence of the lib, if it exists nothing is
# done even if some source files in the lib/src were editited...
$(FEAT):
	@echo "Library" $(@:$(LIBDIR)/lib%.a=%) "is needed by" $(EXEC)
	( cd $(FEATFLOW)/libraries/$(@:$(LIBDIR)/lib%.a=%) && $(MAKE) all )

Deps.mk: $(SRC)
	($(FEATFLOW)/bin/f77mkdep.sh $^ >$@)

clean:
	-rm -f Deps.mk
	-rm -f $(OBJDIR)/*.o 

clean_exec: 
	-rm -f $(EXEC)

purge: clean clean_exec

purge_all: purge
	@(for i in *-*-*-* ; do if [ -x $$i ] ; then echo rm $$i ; rm -f $$i ; fi ; done )
	-rm -f -r obj/*
	-rm -f -r \#gmv/* \#avs/* \#points/* \#ns/* \#film/* \#data/\#DX*
	-rm -f -r \#data/*.ERR \#data/*.PRT \#data/*.SYS \#data/*.TRC 

.NOTPARALLEL: clean purge run

debug: all

run: all
	@(time ./$(EXEC))

id: .id
help: .help
-include Deps.mk

