      SUBROUTINE XOWSC3(MFILE,CFILE)
C
      IMPLICIT DOUBLE PRECISION (A,C-H,O-U,W-Z),LOGICAL(B)
      CHARACTER SUB*6,FMT*15,CPARAM*120
      CHARACTER CFILE*(*)
C
      PARAMETER (NNVE=4,NNARR=299)
      DIMENSION VWORK(1),KWORK(1)
      COMMON          NWORK,IWORK,IWMAX,L(NNARR),DWORK(1)
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /TRIAD/  NEL,NVT,NMT,NVE,NVEL,NBCT,NVBD
      COMMON /TRIAA/  LCORVG,LCORMG,LVERT,LMID,LADJ,LVEL,LMEL,LNPR,LMM,
     *                LVBD,LEBD,LBCT,LVBDP,LMBDP
      EQUIVALENCE (DWORK(1),VWORK(1),KWORK(1))
      SAVE /OUTPUT/,/ERRCTL/,/CHAR/,/TRIAD/,/TRIAA/
C
      SUB='XOWSC3'
      IF (ICHECK.GE.997) CALL OTRC('XOWSC3 ','05/15/95')
      IER=0
C
C *** Open I/O-file
C
      CALL OF0(MFILE,CFILE,1)
      IF (IER.NE.0) GOTO 99999
C
      NVE =8
      NEE =12
      NAE =6
      NBCT=1
C
      WRITE (MFILE,*) 'Coarse mesh 3D'
      WRITE (MFILE,*) 'modified by tr2to3'
      WRITE (MFILE,'(6I8,A)') NEL,NVT,NBCT,NVE,NEE,NAE,
     *                      ' NEL,NVT,NBCT,NVE,NEE,NAE'
C
      CALL OWSC3(MFILE,DWORK(L(LCORVG)),KWORK(L(LVERT)),KWORK(L(LNPR)))
      IF (IER.NE.0) GOTO 99999
C
C
99999 END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE OWSC3(MFILE,DCORVG,KVERT,KNPR)
C
      IMPLICIT DOUBLE PRECISION (A,C-H,O-U,W-Z),LOGICAL(B)
      CHARACTER SUB*6,FMT*15,CPARAM*120
      DIMENSION DCORVG(3,*),KVERT(8,*),KNPR(*)
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /TRIAD/  NEL,NVT,NMT,NVE,NVEL,NBCT,NVBD
      SAVE
C
      SUB='OWSC3'
      IF (ICHECK.GE.997) CALL OTRC('OWSC3 ','05/15/95')
C
      WRITE (MFILE,*) 'DCORVG'
      DO 10 IVT=1,NVT
10    WRITE (MFILE,*) DCORVG(1,IVT),DCORVG(2,IVT),DCORVG(3,IVT)
C
      WRITE (MFILE,*) 'KVERT'
      DO 20 IEL=1,NEL
20    WRITE (MFILE,*) KVERT(1,IEL),KVERT(2,IEL),
     *                KVERT(3,IEL),KVERT(4,IEL),
     *                KVERT(5,IEL),KVERT(6,IEL),
     *                KVERT(7,IEL),KVERT(8,IEL)
C
      WRITE (MFILE,*) 'KNPR'
      DO 30 IVT=1,NVT
30    WRITE (MFILE,*) KNPR(IVT)
C
C
C
99999 END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE GENC3(DCORVG,DCORH,KVERT,KVERTH,KNPR,KNPRH,NEL,NELOLD,
     *                 NVT,NVTOLD,NPZ,PZMIN,PZMAX,PZARR)
      IMPLICIT DOUBLE PRECISION (A,C-H,O-U,W-Z),LOGICAL(B)
      DIMENSION DCORVG(3,*),DCORH(2,*),KVERT(8,*),KVERTH(4,*),
     *          KNPR(*),KNPRH(*),PZARR(*)
C
C
C
      DO 10 IPZ=1,NPZ
C
      DO 20 IELOLD=1,NELOLD
      IEL=IELOLD+(IPZ-1)*NELOLD
      KVERT(1,IEL)=KVERTH(1,IELOLD)+(IPZ-1)*NVTOLD
      KVERT(2,IEL)=KVERTH(2,IELOLD)+(IPZ-1)*NVTOLD
      KVERT(3,IEL)=KVERTH(3,IELOLD)+(IPZ-1)*NVTOLD
      KVERT(4,IEL)=KVERTH(4,IELOLD)+(IPZ-1)*NVTOLD
      KVERT(5,IEL)=KVERTH(1,IELOLD)+ IPZ   *NVTOLD
      KVERT(6,IEL)=KVERTH(2,IELOLD)+ IPZ   *NVTOLD
      KVERT(7,IEL)=KVERTH(3,IELOLD)+ IPZ   *NVTOLD
      KVERT(8,IEL)=KVERTH(4,IELOLD)+ IPZ   *NVTOLD
20    CONTINUE
C
10    CONTINUE
C
C
      DO 30 IVTOLD=1,NVTOLD
C
      IVT=IVTOLD
      DCORVG(1,IVT)=DCORH(1,IVTOLD)
      DCORVG(2,IVT)=DCORH(2,IVTOLD)
      DCORVG(3,IVT)=PZMIN
      KNPR(IVT)    =1
C
      IVT=IVTOLD+NPZ*NVTOLD
      DCORVG(1,IVT)=DCORH(1,IVTOLD)
      DCORVG(2,IVT)=DCORH(2,IVTOLD)
      DCORVG(3,IVT)=PZMAX
      KNPR(IVT)    =1      
C
      INPR=KNPRH(IVTOLD)
      IF (INPR.NE.0) INPR=1
C
      DO 40 IPZ=1,NPZ-1
      IVT=IVTOLD+IPZ*NVTOLD
      DCORVG(1,IVT)=DCORH(1,IVTOLD)
      DCORVG(2,IVT)=DCORH(2,IVTOLD)
      DCORVG(3,IVT)=PZARR(IPZ)
      KNPR(IVT)    =INPR
40    CONTINUE
C
30    CONTINUE
C
C
C
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE AVSTR(MUNIT,CFILE,NEL,NVT,KVERT,DCORVG)
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B)
C
      CHARACTER SUB*6,FMT*15,CPARAM*120
      CHARACTER CFILE*15
      DIMENSION KVERT(8,*),DCORVG(3,*)
C
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      SAVE
C
C
C
      OPEN (UNIT=MUNIT,FILE=CFILE)
C
C
      WRITE(MUNIT,*) NVT,NEL,1,1,0
C
      DO 100 IVT=1,NVT
100   WRITE(MUNIT,1000) IVT,REAL(DCORVG(1,IVT)),REAL(DCORVG(2,IVT)),
     *                      REAL(DCORVG(3,IVT))
C
      DO 110 IEL=1,NEL
110   WRITE(MUNIT,1100) IEL,1,'hex',KVERT(1,IEL),KVERT(2,IEL),
     *                              KVERT(3,IEL),KVERT(4,IEL),
     *                              KVERT(5,IEL),KVERT(6,IEL),
     *                              KVERT(7,IEL),KVERT(8,IEL)
C
C
      WRITE(MUNIT,*) 1,1
      WRITE(MUNIT,*)  'NODES'//',','NUMBERS'      
C
      DO 200 IVT=1,NVT
200   WRITE(MUNIT,2000) IVT,REAL(IVT)
C
C
      WRITE(MUNIT,*) 1,1
      WRITE(MUNIT,*)  'CELLS'//',','NUMBERS'      
C
      DO 300 IEL=1,NEL
300   WRITE(MUNIT,3000) IEL,REAL(IEL)
C
C
1000  FORMAT(I8,3E15.8)
1100  FORMAT(2I8,A7,8I8)
2000  FORMAT(I8,1E15.8)
3000  FORMAT(I8,1E15.8)
C
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE GMVTR(MUNIT,CFILE,NEL,NVT,KVERT,DCORVG)
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B)
C
      CHARACTER SUB*6,FMT*15,CPARAM*120
      CHARACTER CFILE*15
      DIMENSION KVERT(8,*),DCORVG(3,*)
C
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      SAVE
C
C
C
      OPEN (UNIT=MUNIT,FILE=CFILE)
C
C
      WRITE(MUNIT,'(A)')'gmvinput ascii'
      WRITE(MUNIT,*)'nodes ',NVT
C
      DO 100 IVT=1,NVT
100   WRITE(MUNIT,1000) REAL(DCORVG(1,IVT))
      DO 101 IVT=1,NVT
101   WRITE(MUNIT,1000) REAL(DCORVG(2,IVT))
      DO 102 IVT=1,NVT
102   WRITE(MUNIT,1000) REAL(DCORVG(3,IVT))
C
      WRITE(MUNIT,*)'cells ',NEL
      DO 110 IEL=1,NEL
      WRITE(MUNIT,*)'hex 8'
110   WRITE(MUNIT,1100) KVERT(1,IEL),KVERT(2,IEL),
     *                  KVERT(3,IEL),KVERT(4,IEL),
     *                  KVERT(5,IEL),KVERT(6,IEL),
     *                  KVERT(7,IEL),KVERT(8,IEL)
C
C
      WRITE(MUNIT,*)  'endgmv'
C
C
1000  FORMAT(E15.8)
1100  FORMAT(8I8)
C
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE BYUTR(MUNIT,CFILE,NEL,NVT,KVERT,KMOVV,DCORVG)
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B)
C
      CHARACTER SUB*6,FMT*15,CPARAM*120
      CHARACTER CFILE*15
      DIMENSION KVERT(8,*),KMOVV(*),DCORVG(*)
C
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      SAVE
C
C
C
      OPEN (UNIT=MUNIT,FILE=CFILE)
C
C
      NP   =   1
      NJ   =   NVT
      NPT  = 6*NEL
      NEDGE=24*NEL
      NPTH =   1
C
      WRITE (MUNIT,'(4I8)') NP,NJ,NPT,NEDGE
      WRITE (MUNIT,'(2I8)') NPTH,NPT
C
      WRITE (MUNIT,'(1P6E12.5)') (REAL(DCORVG(I)),I=1,3*NVT)
C
      WRITE (MUNIT,'(10I8)')     (KMOVV(I),I=1,NEDGE)
C
C
C
99999 END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE MOVV(KVERMO,KVERT,NEL)
      IMPLICIT DOUBLE PRECISION (A,C-H,O-U,W-Z),LOGICAL(B)
      DIMENSION KVERMO(*),KVERT(8,*)
      DIMENSION KIAD(4,6)

      DATA KIAD/1,2,3,4,1,2,6,5,2,3,7,6,3,4,8,7,4,1,5,8,5,6,7,8/
C
      NAE=6
C
      DO 1 IEL=1,NEL
      DO 2 IAR=1,NAE
      DO 3 IVE=1,3
3     KVERMO((IEL-1)*NAE*4+(IAR-1)*4+IVE)= KVERT(KIAD(IVE,IAR),IEL)
2     KVERMO((IEL-1)*NAE*4+IAR*4)=        -KVERT(KIAD(  4,IAR),IEL)
1     CONTINUE
C
      END
