      SUBROUTINE XOWSC3(MFILE,CFILE)
C
      IMPLICIT DOUBLE PRECISION (A,C-H,O-U,W-Z),LOGICAL(B)
      CHARACTER SUB*6,FMT*15,CPARAM*120
      CHARACTER CFILE*(*)
C
      PARAMETER (NNVE=4,NNARR=299)
      DIMENSION VWORK(1),KWORK(1)
      COMMON          NWORK,IWORK,IWMAX,L(NNARR),DWORK(1)
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /TRIAD/  NEL,NVT,NMT,NVE,NVEL,NBCT,NVBD
      COMMON /TRIAA/  LCORVG,LCORMG,LVERT,LMID,LADJ,LVEL,LMEL,LNPR,LMM,
     *                LVBD,LEBD,LBCT,LVBDP,LMBDP
      EQUIVALENCE (DWORK(1),VWORK(1),KWORK(1))
      SAVE /OUTPUT/,/ERRCTL/,/CHAR/,/TRIAD/,/TRIAA/
C
      SUB='XOWSC3'
      IF (ICHECK.GE.997) CALL OTRC('XOWSC3 ','05/15/95')
      IER=0
C
C *** Open I/O-file
C
      CALL OF0(MFILE,CFILE,1)
      IF (IER.NE.0) GOTO 99999
C
      NVE =8
      NEE =12
      NAE =6
      NBCT=1
C
      WRITE (MFILE,*) 'Coarse mesh 3D'
      WRITE (MFILE,*) 'modified by tr2to3'
      WRITE (MFILE,'(6I8,A)') NEL,NVT,NBCT,NVE,NEE,NAE,
     *                      ' NEL,NVT,NBCT,NVE,NEE,NAE'
C
      CALL OWSC3(MFILE,DWORK(L(LCORVG)),KWORK(L(LVERT)),KWORK(L(LNPR)))
      IF (IER.NE.0) GOTO 99999
C
C
99999 END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE OWSC3(MFILE,DCORVG,KVERT,KNPR)
C
      IMPLICIT DOUBLE PRECISION (A,C-H,O-U,W-Z),LOGICAL(B)
      CHARACTER SUB*6,FMT*15,CPARAM*120
      DIMENSION DCORVG(3,*),KVERT(8,*),KNPR(*)
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /TRIAD/  NEL,NVT,NMT,NVE,NVEL,NBCT,NVBD
      SAVE
C
      SUB='OWSC3'
      IF (ICHECK.GE.997) CALL OTRC('OWSC3 ','05/15/95')
C
      WRITE (MFILE,*) 'DCORVG'
      DO 10 IVT=1,NVT
10    WRITE (MFILE,*) DCORVG(1,IVT),DCORVG(2,IVT),DCORVG(3,IVT)
C
      WRITE (MFILE,*) 'KVERT'
      DO 20 IEL=1,NEL
20    WRITE (MFILE,*) KVERT(1,IEL),KVERT(2,IEL),
     *                KVERT(3,IEL),KVERT(4,IEL),
     *                KVERT(5,IEL),KVERT(6,IEL),
     *                KVERT(7,IEL),KVERT(8,IEL)
C
      WRITE (MFILE,*) 'KNPR'
      DO 30 IVT=1,NVT
30    WRITE (MFILE,*) KNPR(IVT)
C
C
C
99999 END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE GENC3(DCORVG,DCORH,KVERT,KVERTH,KNPR,KNPRH,NEL,NELOLD,
     *                 NVT,NVTOLD,NPZ,PZMIN,PZMAX,PZARR)
      IMPLICIT DOUBLE PRECISION (A,C-H,O-U,W-Z),LOGICAL(B)
      DIMENSION DCORVG(3,*),DCORH(2,*),KVERT(8,*),KVERTH(4,*),
     *          KNPR(*),KNPRH(*),PZARR(*)
C
C
C
      DO 10 IPZ=1,NPZ
C
      DO 20 IELOLD=1,NELOLD
      IEL=IELOLD+(IPZ-1)*NELOLD
      KVERT(1,IEL)=KVERTH(1,IELOLD)+(IPZ-1)*NVTOLD
      KVERT(2,IEL)=KVERTH(2,IELOLD)+(IPZ-1)*NVTOLD
      KVERT(3,IEL)=KVERTH(3,IELOLD)+(IPZ-1)*NVTOLD
      KVERT(4,IEL)=KVERTH(4,IELOLD)+(IPZ-1)*NVTOLD
      KVERT(5,IEL)=KVERTH(1,IELOLD)+ IPZ   *NVTOLD
      KVERT(6,IEL)=KVERTH(2,IELOLD)+ IPZ   *NVTOLD
      KVERT(7,IEL)=KVERTH(3,IELOLD)+ IPZ   *NVTOLD
      KVERT(8,IEL)=KVERTH(4,IELOLD)+ IPZ   *NVTOLD
20    CONTINUE
C
10    CONTINUE
C
C
      DO 30 IVTOLD=1,NVTOLD
C
      IVT=IVTOLD
      DCORVG(1,IVT)=DCORH(1,IVTOLD)
      DCORVG(2,IVT)=DCORH(2,IVTOLD)
      DCORVG(3,IVT)=PZMIN
      KNPR(IVT)    =1
C
      IVT=IVTOLD+NPZ*NVTOLD
      DCORVG(1,IVT)=DCORH(1,IVTOLD)
      DCORVG(2,IVT)=DCORH(2,IVTOLD)
      DCORVG(3,IVT)=PZMAX
      KNPR(IVT)    =1      
C
      INPR=KNPRH(IVTOLD)
      IF (INPR.NE.0) INPR=1
C
      DO 40 IPZ=1,NPZ-1
      IVT=IVTOLD+IPZ*NVTOLD
      DCORVG(1,IVT)=DCORH(1,IVTOLD)
      DCORVG(2,IVT)=DCORH(2,IVTOLD)
      DCORVG(3,IVT)=PZARR(IPZ)
      KNPR(IVT)    =INPR
40    CONTINUE
C
30    CONTINUE
C
C
C
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE AVSTR(MUNIT,CFILE,NEL,NVT,KVERT,DCORVG)
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B)
C
      CHARACTER SUB*6,FMT*15,CPARAM*120
      CHARACTER CFILE*15
      DIMENSION KVERT(8,*),DCORVG(3,*)
C
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      SAVE
C
C
C
      OPEN (UNIT=MUNIT,FILE=CFILE)
C
C
      WRITE(MUNIT,*) NVT,NEL,1,1,0
C
      DO 100 IVT=1,NVT
100   WRITE(MUNIT,1000) IVT,REAL(DCORVG(1,IVT)),REAL(DCORVG(2,IVT)),
     *                      REAL(DCORVG(3,IVT))
C
      DO 110 IEL=1,NEL
110   WRITE(MUNIT,1100) IEL,1,'hex',KVERT(1,IEL),KVERT(2,IEL),
     *                              KVERT(3,IEL),KVERT(4,IEL),
     *                              KVERT(5,IEL),KVERT(6,IEL),
     *                              KVERT(7,IEL),KVERT(8,IEL)
C
C
      WRITE(MUNIT,*) 1,1
      WRITE(MUNIT,*)  'NODES'//',','NUMBERS'      
C
      DO 200 IVT=1,NVT
200   WRITE(MUNIT,2000) IVT,REAL(IVT)
C
C
      WRITE(MUNIT,*) 1,1
      WRITE(MUNIT,*)  'CELLS'//',','NUMBERS'      
C
      DO 300 IEL=1,NEL
300   WRITE(MUNIT,3000) IEL,REAL(IEL)
C
C
1000  FORMAT(I8,3E15.8)
1100  FORMAT(2I8,A7,8I8)
2000  FORMAT(I8,1E15.8)
3000  FORMAT(I8,1E15.8)
C
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE GMVTR(MUNIT,CFILE,NEL,NVT,KVERT,DCORVG)
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B)
C
      CHARACTER SUB*6,FMT*15,CPARAM*120
      CHARACTER CFILE*15
      DIMENSION KVERT(8,*),DCORVG(3,*)
C
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      SAVE
C
C
C
      OPEN (UNIT=MUNIT,FILE=CFILE)
C
C
      WRITE(MUNIT,'(A)')'gmvinput ascii'
      WRITE(MUNIT,*)'nodes ',NVT
C
      DO 100 IVT=1,NVT
100   WRITE(MUNIT,1000) REAL(DCORVG(1,IVT))
      DO 101 IVT=1,NVT
101   WRITE(MUNIT,1000) REAL(DCORVG(2,IVT))
      DO 102 IVT=1,NVT
102   WRITE(MUNIT,1000) REAL(DCORVG(3,IVT))
C
      WRITE(MUNIT,*)'cells ',NEL
      DO 110 IEL=1,NEL
      WRITE(MUNIT,*)'hex 8'
110   WRITE(MUNIT,1100) KVERT(1,IEL),KVERT(2,IEL),
     *                  KVERT(3,IEL),KVERT(4,IEL),
     *                  KVERT(5,IEL),KVERT(6,IEL),
     *                  KVERT(7,IEL),KVERT(8,IEL)
C
C
      WRITE(MUNIT,*)  'endgmv'
C
C
1000  FORMAT(E15.8)
1100  FORMAT(8I8)
C
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE BYUTR(MUNIT,CFILE,NEL,NVT,KVERT,KMOVV,DCORVG)
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B)
C
      CHARACTER SUB*6,FMT*15,CPARAM*120
      CHARACTER CFILE*15
      DIMENSION KVERT(8,*),KMOVV(*),DCORVG(*)
C
      COMMON /ERRCTL/ IER,ICHECK
      COMMON /CHAR/   SUB,FMT(3),CPARAM
      COMMON /OUTPUT/ M,MT,MKEYB,MTERM,MERR,MPROT,MSYS,MTRC,IRECL8
      SAVE
C
C
C
      OPEN (UNIT=MUNIT,FILE=CFILE)
C
C
      NP   =   1
      NJ   =   NVT
      NPT  = 6*NEL
      NEDGE=24*NEL
      NPTH =   1
C
      WRITE (MUNIT,'(4I8)') NP,NJ,NPT,NEDGE
      WRITE (MUNIT,'(2I8)') NPTH,NPT
C
      WRITE (MUNIT,'(1P6E12.5)') (REAL(DCORVG(I)),I=1,3*NVT)
C
      WRITE (MUNIT,'(10I8)')     (KMOVV(I),I=1,NEDGE)
C
C
C
99999 END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE MOVV(KVERMO,KVERT,NEL)
      IMPLICIT DOUBLE PRECISION (A,C-H,O-U,W-Z),LOGICAL(B)
      DIMENSION KVERMO(*),KVERT(8,*)
      DIMENSION KIAD(4,6)
      DATA KIAD/1,2,3,4,1,2,6,5,2,3,7,6,3,4,8,7,4,1,5,8,5,6,7,8/
      SAVE
C
      NAE=6
C
      DO 1 IEL=1,NEL
      DO 2 IAR=1,NAE
      DO 3 IVE=1,3
3     KVERMO((IEL-1)*NAE*4+(IAR-1)*4+IVE)= KVERT(KIAD(IVE,IAR),IEL)
2     KVERMO((IEL-1)*NAE*4+IAR*4)=        -KVERT(KIAD(  4,IAR),IEL)
1     CONTINUE
C
      END
C
C
C
************************************************************************
      SUBROUTINE CHCOOR(DCORVG,KVERT,KAREA,KADJ,KNPR,NEL,NVT)
      IMPLICIT DOUBLE PRECISION (A,C-H,O-U,W-Z),LOGICAL(B)
      DIMENSION DCORVG(3,*),KVERT(8,*),KAREA(6,*),KADJ(6,*),KNPR(*)
C
C
C
      DO 100 IEL=1,NEL/8
C
      IEL1=IEL
      IEL2=KADJ(3,IEL1)
      IEL3=KADJ(3,IEL2)
      IEL4=KADJ(3,IEL3)
      IEL5=KADJ(6,IEL1)
      IEL6=KADJ(3,IEL5)
      IEL7=KADJ(3,IEL6)
      IEL8=KADJ(3,IEL7)
C
      IADJ1=KADJ(1,IEL1)
      IADJ2=KADJ(2,IEL1)
      IADJ3=KADJ(2,IEL2)
      IADJ4=KADJ(2,IEL3)
      IADJ5=KADJ(2,IEL4)
      IADJ6=KADJ(1,IEL5)
C
      IVT1=KVERT(3,IEL1)
      IVT2=KVERT(6,IEL1)
      IVT3=KVERT(6,IEL2)
      IVT4=KVERT(6,IEL3)
      IVT5=KVERT(6,IEL4)
      IVT6=KVERT(3,IEL5)
C
      JVT1 =KVERT(2,IEL1)
      JVT2 =KVERT(2,IEL2)
      JVT3 =KVERT(2,IEL3)
      JVT4 =KVERT(2,IEL4)
      JVT5 =KVERT(5,IEL1)
      JVT6 =KVERT(5,IEL2)
      JVT7 =KVERT(5,IEL3)
      JVT8 =KVERT(5,IEL4)
      JVT9 =KVERT(2,IEL5)
      JVT10=KVERT(2,IEL6)
      JVT11=KVERT(2,IEL7)
      JVT12=KVERT(2,IEL8)
C
      NADJ0=0
      IF (IADJ1.EQ.0) NADJ0=NADJ0+1
      IF (IADJ2.EQ.0) NADJ0=NADJ0+1
      IF (IADJ3.EQ.0) NADJ0=NADJ0+1
      IF (IADJ4.EQ.0) NADJ0=NADJ0+1
      IF (IADJ5.EQ.0) NADJ0=NADJ0+1
      IF (IADJ6.EQ.0) NADJ0=NADJ0+1
C
C
      IF (NADJ0.EQ.0) GOTO 100
C
C
      QX1 =DCORVG(1,JVT1)
      QX2 =DCORVG(1,JVT2)
      QX3 =DCORVG(1,JVT3)
      QX4 =DCORVG(1,JVT4)
      QX5 =DCORVG(1,JVT5)
      QX6 =DCORVG(1,JVT6)
      QX7 =DCORVG(1,JVT7)
      QX8 =DCORVG(1,JVT8)
      QX9 =DCORVG(1,JVT9)
      QX10=DCORVG(1,JVT10)
      QX11=DCORVG(1,JVT11)
      QX12=DCORVG(1,JVT12)
C
      QY1 =DCORVG(2,JVT1)
      QY2 =DCORVG(2,JVT2)
      QY3 =DCORVG(2,JVT3)
      QY4 =DCORVG(2,JVT4)
      QY5 =DCORVG(2,JVT5)
      QY6 =DCORVG(2,JVT6)
      QY7 =DCORVG(2,JVT7)
      QY8 =DCORVG(2,JVT8)
      QY9 =DCORVG(2,JVT9)
      QY10=DCORVG(2,JVT10)
      QY11=DCORVG(2,JVT11)
      QY12=DCORVG(2,JVT12)
C
      QZ1 =DCORVG(3,JVT1)
      QZ2 =DCORVG(3,JVT2)
      QZ3 =DCORVG(3,JVT3)
      QZ4 =DCORVG(3,JVT4)
      QZ5 =DCORVG(3,JVT5)
      QZ6 =DCORVG(3,JVT6)
      QZ7 =DCORVG(3,JVT7)
      QZ8 =DCORVG(3,JVT8)
      QZ9 =DCORVG(3,JVT9)
      QZ10=DCORVG(3,JVT10)
      QZ11=DCORVG(3,JVT11)
      QZ12=DCORVG(3,JVT12)
C
C
      IF (NADJ0.EQ.1) THEN
       IF ((IADJ1.EQ.0).OR.(IADJ6.EQ.0)) THEN
        DCORVG(1,IVT2)=0.5D0*(QX1 +QX9)
        DCORVG(2,IVT2)=0.5D0*(QY1 +QY9)
        DCORVG(3,IVT2)=0.5D0*(QZ1 +QZ9)
        DCORVG(1,IVT3)=0.5D0*(QX2 +QX10)
        DCORVG(2,IVT3)=0.5D0*(QY2 +QY10)
        DCORVG(3,IVT3)=0.5D0*(QZ2 +QZ10)
        DCORVG(1,IVT4)=0.5D0*(QX3 +QX11)
        DCORVG(2,IVT4)=0.5D0*(QY3 +QY11)
        DCORVG(3,IVT4)=0.5D0*(QZ3 +QZ11)
        DCORVG(1,IVT5)=0.5D0*(QX4 +QX12)
        DCORVG(2,IVT5)=0.5D0*(QY4 +QY12)
        DCORVG(3,IVT5)=0.5D0*(QZ4 +QZ12)
       ENDIF
       IF ((IADJ2.EQ.0).OR.(IADJ4.EQ.0)) THEN
        DCORVG(1,IVT1)=0.5D0*(QX1 +QX3)
        DCORVG(2,IVT1)=0.5D0*(QY1 +QY3)
        DCORVG(3,IVT1)=0.5D0*(QZ1 +QZ3)
        DCORVG(1,IVT3)=0.5D0*(QX6 +QX7)
        DCORVG(2,IVT3)=0.5D0*(QY6 +QY7)
        DCORVG(3,IVT3)=0.5D0*(QZ6 +QZ7)
        DCORVG(1,IVT5)=0.5D0*(QX5 +QX8)
        DCORVG(2,IVT5)=0.5D0*(QY5 +QY8)
        DCORVG(3,IVT5)=0.5D0*(QZ5 +QZ8)
        DCORVG(1,IVT6)=0.5D0*(QX9 +QX11)
        DCORVG(2,IVT6)=0.5D0*(QY9 +QY11)
        DCORVG(3,IVT6)=0.5D0*(QZ9 +QZ11)
       ENDIF
       IF ((IADJ3.EQ.0).OR.(IADJ5.EQ.0)) THEN
        DCORVG(1,IVT1)=0.5D0*(QX2 +QX4)
        DCORVG(2,IVT1)=0.5D0*(QY2 +QY4)
        DCORVG(3,IVT1)=0.5D0*(QZ2 +QZ4)
        DCORVG(1,IVT2)=0.5D0*(QX5 +QX6)
        DCORVG(2,IVT2)=0.5D0*(QY5 +QY6)
        DCORVG(3,IVT2)=0.5D0*(QZ5 +QZ6)
        DCORVG(1,IVT4)=0.5D0*(QX7 +QX8)
        DCORVG(2,IVT4)=0.5D0*(QY7 +QY8)
        DCORVG(3,IVT4)=0.5D0*(QZ7 +QZ8)
        DCORVG(1,IVT6)=0.5D0*(QX10+QX12)
        DCORVG(2,IVT6)=0.5D0*(QY10+QY12)
        DCORVG(3,IVT6)=0.5D0*(QZ10+QZ12)
       ENDIF
      ENDIF
C
      IF (NADJ0.GT.1) THEN
       DCORVG(1,IVT1)=0.25D0*(QX1 +QX2 +QX3 +QX4)
       DCORVG(1,IVT2)=0.25D0*(QX1 +QX5 +QX6 +QX9)
       DCORVG(1,IVT3)=0.25D0*(QX2 +QX6 +QX7 +QX10)
       DCORVG(1,IVT4)=0.25D0*(QX3 +QX7 +QX8 +QX11)
       DCORVG(1,IVT5)=0.25D0*(QX4 +QX5 +QX8 +QX12)
       DCORVG(1,IVT6)=0.25D0*(QX9 +QX10+QX11+QX12)
       DCORVG(2,IVT1)=0.25D0*(QY1 +QY2 +QY3 +QY4)
       DCORVG(2,IVT2)=0.25D0*(QY1 +QY5 +QY6 +QY9)
       DCORVG(2,IVT3)=0.25D0*(QY2 +QY6 +QY7 +QY10)
       DCORVG(2,IVT4)=0.25D0*(QY3 +QY7 +QY8 +QY11)
       DCORVG(2,IVT5)=0.25D0*(QY4 +QY5 +QY8 +QY12)
       DCORVG(2,IVT6)=0.25D0*(QY9 +QY10+QY11+QY12)
       DCORVG(3,IVT1)=0.25D0*(QZ1 +QZ2 +QZ3 +QZ4)
       DCORVG(3,IVT2)=0.25D0*(QZ1 +QZ5 +QZ6 +QZ9)
       DCORVG(3,IVT3)=0.25D0*(QZ2 +QZ6 +QZ7 +QZ10)
       DCORVG(3,IVT4)=0.25D0*(QZ3 +QZ7 +QZ8 +QZ11)
       DCORVG(3,IVT5)=0.25D0*(QZ4 +QZ5 +QZ8 +QZ12)
       DCORVG(3,IVT6)=0.25D0*(QZ9 +QZ10+QZ11+QZ12)
      ENDIF
C
C
      IVTM=KVERT(7,IEL)
      PXM=DCORVG(1,IVTM)
      PYM=DCORVG(2,IVTM)
      PZM=DCORVG(3,IVTM)
C
      PX1=DCORVG(1,IVT1)
      PX2=DCORVG(1,IVT2)
      PX3=DCORVG(1,IVT3)
      PX4=DCORVG(1,IVT4)
      PX5=DCORVG(1,IVT5)
      PX6=DCORVG(1,IVT6)
C
      PY1=DCORVG(2,IVT1)
      PY2=DCORVG(2,IVT2)
      PY3=DCORVG(2,IVT3)
      PY4=DCORVG(2,IVT4)
      PY5=DCORVG(2,IVT5)
      PY6=DCORVG(2,IVT6)
C
      PZ1=DCORVG(3,IVT1)
      PZ2=DCORVG(3,IVT2)
      PZ3=DCORVG(3,IVT3)
      PZ4=DCORVG(3,IVT4)
      PZ5=DCORVG(3,IVT5)
      PZ6=DCORVG(3,IVT6)
C
      IF (NADJ0.EQ.1) THEN
       IF ((IADJ1.EQ.0).OR.(IADJ6.EQ.0)) THEN
        PX=0.5D0*(PX1+PX6)
        PY=0.5D0*(PY1+PY6)
        PZ=0.5D0*(PZ1+PZ6)
       ENDIF
       IF ((IADJ2.EQ.0).OR.(IADJ4.EQ.0)) THEN
        PX=0.5D0*(PX2+PX4)
        PY=0.5D0*(PY2+PY4)
        PZ=0.5D0*(PZ2+PZ4)
       ENDIF
       IF ((IADJ3.EQ.0).OR.(IADJ5.EQ.0)) THEN
        PX=0.5D0*(PX3+PX5)
        PY=0.5D0*(PY3+PY5)
        PZ=0.5D0*(PZ3+PZ5)
       ENDIF
       DCORVG(1,IVTM)=PX
       DCORVG(2,IVTM)=PY
       DCORVG(3,IVTM)=PZ
      ENDIF
C
C      
      IF (NADJ0.GT.1) THEN
       PX=1D0/6D0*(PX1+PX2+PX3+PX4+PX5+PX6)
       PY=1D0/6D0*(PY1+PY2+PY3+PY4+PY5+PY6)
       PZ=1D0/6D0*(PZ1+PZ2+PZ3+PZ4+PZ5+PZ6)
       DCORVG(1,IVTM)=PX
       DCORVG(2,IVTM)=PY
       DCORVG(3,IVTM)=PZ
      ENDIF
C
C
100   CONTINUE
C
C
C
      END
C
C
C
