************************************************************************
* FINITE ELEMENT ANALYSIS TOOLBOX  FEAT  (Release 1.3)                 *
*                                                                      *
* Authors: H. Blum, J. Harig, S. Mueller, S. Turek                     *
*          Institute of Applied Mathematics                            *
*          University of Heidelberg                                    *
*          D-6900 HEIDELBERG                                           *
*                                                                      *
************************************************************************
*                                                                      *
* MP0nn                                                                *
*                                                                      *
* written by:  S. Turek                                                *
*                                                                      *
* Purpose  Multigrid prolongation  (version 0)                         *
*          nn refers to elementtype                                    *
*          Double precision version                                    *
*          The meshes are assumed to be generated by SA0 or SB0,       *
*          same numbering conventions for vertices and elements        *
*          Uniform refinement assumed                                  *
*                                                                      *
* Subroutines/functions called   LCP1                                  *
*                                                                      *
* Version from  01/25/90                                               *
*                                                                      *
*                                                                      *
* INPUT    TYPE                                                        *
* -----    ----                                                        *
* DU1      R*8    Vector on coarse grid                                *
* KVERT1   I*4                                                         *
* KVERT2   I*4                                                         *
* KMID1    I*4    1 fine grid information                              *
* KMID2    I*4    2 fine grid information                              *
* KADJ1    I*4                                                         *
* KADJ2    I*4                                                         *
* NVT1     I*4                                                         *
* NVT2     I*4                                                         *
* NEL1     I*4                                                         *
* NEL2     I*4                                                         *
*                                                                      *
* OUTPUT   TYPE                                                        *
* ------   ----                                                        *
* DU2      R*8    Vector on fine grid                                  *
*                                                                      *
************************************************************************
C
      SUBROUTINE MP001(DU1,DU2,KVERT1,KVERT2,KADJ1,NVT1,NEL1)
C
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B) 
      PARAMETER (NNVE=4)
      PARAMETER (Q2=.5D0)
      DIMENSION DU1(*),DU2(*)
      DIMENSION KVERT1(NNVE,*),KVERT2(NNVE,*)
      DIMENSION KADJ1(NNVE,*)
      COMMON /ERRCTL/ IER,ICHECK
      SAVE /ERRCTL/
C
      IF (ICHECK.GE.998) CALL OTRC('MP001 ','01/25/90')
C
      CALL LCP1(DU1,DU2,NVT1)
C
      DO 10 IEL1=1,NEL1
C
      DUH1=DU1(KVERT1(1,IEL1))
      DUH2=DU1(KVERT1(2,IEL1))
      DUH3=DU1(KVERT1(3,IEL1))
C
      IF (KADJ1(1,IEL1).LT.IEL1) 
     *   DU2(KVERT2(1,IEL1))=Q2*(DUH1+DUH2)
C
      IF (KADJ1(2,IEL1).LT.IEL1) 
     *   DU2(KVERT2(2,IEL1))=Q2*(DUH2+DUH3)
C
      IF (KADJ1(3,IEL1).LT.IEL1) 
     *   DU2(KVERT2(3,IEL1))=Q2*(DUH3+DUH1)
C
10    CONTINUE
C
      END
C
C
C
C
      SUBROUTINE MP011(DU1,DU2,KVERT1,KVERT2,KADJ1,KADJ2,NVT1,NEL1)
C
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B) 
      PARAMETER (NNVE=4)
      PARAMETER (Q2=.5D0,Q4=.25D0)
      DIMENSION DU1(*),DU2(*)
      DIMENSION KVERT1(NNVE,*),KVERT2(NNVE,*)
      DIMENSION KADJ1(NNVE,*),KADJ2(NNVE,*)
      COMMON /ERRCTL/ IER,ICHECK
      SAVE /ERRCTL/
C
      IF (ICHECK.GE.998) CALL OTRC('MP011 ','01/25/90')
C
      CALL LCP1(DU1,DU2,NVT1)
C
      DO 10 IEL1=1,NEL1
C
      DUH1=DU1(KVERT1(1,IEL1))
      DUH2=DU1(KVERT1(2,IEL1))
      DUH3=DU1(KVERT1(3,IEL1))
      DUH4=DU1(KVERT1(4,IEL1))
C
      IELH1=IEL1
      IELH2=KADJ2(2,IELH1)
      IELH3=KADJ2(2,IELH2)
      IELH4=KADJ2(2,IELH3)
C
      IF (KADJ1(1,IEL1).LT.IEL1)
     *   DU2(KVERT2(2,IEL1))=Q2*(DUH1+DUH2)
C
      IF (KADJ1(2,IEL1).LT.IEL1) 
     *   DU2(KVERT2(2,IELH2))=Q2*(DUH2+DUH3)
C
      IF (KADJ1(3,IEL1).LT.IEL1) 
     *   DU2(KVERT2(2,IELH3))=Q2*(DUH3+DUH4)
C
      IF (KADJ1(4,IEL1).LT.IEL1) 
     *   DU2(KVERT2(2,IELH4))=Q2*(DUH4+DUH1)
C
      DU2(KVERT2(3,IEL1))=Q4*(DUH1+DUH2+DUH3+DUH4)
C
10    CONTINUE
C
      END
