************************************************************************
* FINITE ELEMENT ANALYSIS TOOLBOX  FEAT  (Release 1.3)                 *
*                                                                      *
* Authors: H. Blum, J. Harig, S. Mueller, S. Turek                     *
*          Institute of Applied Mathematics                            *
*          University of Heidelberg                                    *
*          D-6900 HEIDELBERG                                           *
*                                                                      *
************************************************************************
*                                                                      *
* MR0nn                                                                *
*                                                                      *
* written by:  S. Turek                                                *
*                                                                      *
* Purpose  Multigrid restriction (version 0)                           *
*          nn refers to elementtype                                    *
*          Double precision version                                    *
*          The meshes are assumed to be generated by SA0 or SB0,       *
*          same numbering conventions for vertices and elements        *
*          Uniform refinement assumed                                  *
*                                                                      *
* Subroutines/functions called   LCP1                                  *
*                                                                      *
* Version from  01/25/90                                               *
*                                                                      *
*                                                                      *
* INPUT    TYPE                                                        *
* -----    ----                                                        *
* DU2      R*8    Vector on fine grid                                  *
* KVERT1   I*4                                                         *
* KVERT2   I*4                                                         *
* KMID1    I*4    1 fine grid information                              *
* KMID2    I*4    2 fine grid information                              *
* KADJ1    I*4                                                         *
* KADJ2    I*4                                                         *
* NVT1     I*4                                                         *
* NVT2     I*4                                                         *
* NEL1     I*4                                                         *
* NEL2     I*4                                                         *
*                                                                      *
* OUTPUT   TYPE                                                        *
* ------   ----                                                        *
* DU1      R*8    Vector on coarse grid                                *
*                                                                      *
************************************************************************
C
      SUBROUTINE MR001(DU2,DU1,KVERT2,KADJ2,NVT1,NEL2,NEL1)
C
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B) 
      PARAMETER (NNVE=4)
      PARAMETER (Q2=.5D0)
      DIMENSION DU2(*),DU1(*)
      DIMENSION KVERT2(NNVE,*)
      DIMENSION KADJ2(NNVE,*)
      COMMON /ERRCTL/ IER,ICHECK
      SAVE /ERRCTL/
C
      IF (ICHECK.GE.998) CALL OTRC('MR001 ','01/25/90')
C
      CALL LCP1(DU2,DU1,NVT1)
C
      DO 10 IEL2=NEL1+1,NEL2
      IH1=KVERT2(1,IEL2)
C
      IF (KADJ2(1,IEL2).LT.IEL2) 
     *    DU1(IH1)=DU1(IH1)+Q2*DU2(KVERT2(2,IEL2))
      IF (KADJ2(3,IEL2).LT.IEL2) 
     *    DU1(IH1)=DU1(IH1)+Q2*DU2(KVERT2(3,IEL2))
C
10    CONTINUE
C
      END
C
C
C
C
C
      SUBROUTINE MR011(DX2,DX1,KVERT2,KADJ2,NVT1,NEL2)
      IMPLICIT DOUBLE PRECISION(A,C-H,O-U,W-Z),LOGICAL(B) 
      PARAMETER (NNVE=4)
      PARAMETER (Q4=.25D0)
      DIMENSION DX1(*),DX2(*)
      DIMENSION KVERT2(NNVE,*),KADJ2(NNVE,*)
C
      CALL LCP1(DX2,DX1,NVT1)
C
      DO 10 IEL2=1,NEL2
C
      I1=KVERT2(1,IEL2)
      I2=KVERT2(2,IEL2)
      I3=KVERT2(3,IEL2)
      I4=KVERT2(4,IEL2)
C
      DX1(I1)=DX1(I1)+Q4*(DX2(I2)+DX2(I3)+DX2(I4))
      IF (KADJ2(1,IEL2).EQ.0) DX1(I1)=DX1(I1)+Q4*DX2(I2)
      IF (KADJ2(4,IEL2).EQ.0) DX1(I1)=DX1(I1)+Q4*DX2(I4)
C
10    CONTINUE
C
      END

